package cn.com.duiba.live.clue.service.api.remoteservice.conf.mall.marketing;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.mall.marketing.MallMarketingAfterPayConfDetailDto;
import cn.com.duiba.live.clue.service.api.dto.conf.mall.marketing.MallMarketingAfterPayConfDto;

import java.util.List;

/**
 * 支付后营销配置表
 *
 * @author kjj mybatis generator
 * @date 2022-11-08
 */
@AdvancedFeignClient
public interface RemoteMallMarketingAfterPayConfService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 支付后营销配置
     */
    MallMarketingAfterPayConfDto findById(Long id);

    /**
     * 根据直播id查询
     *
     * @param liveId 直播id
     * @return 支付后营销配置
     */
    List<MallMarketingAfterPayConfDto> listByLiveId(Long liveId);

    /**
     * 新增/更新营销配置
     *
     * @param dto 营销配置
     * @return 执行结果
     */
    int saveOrUpdate(MallMarketingAfterPayConfDetailDto dto);

    /**
     * 软删
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}