package cn.com.duiba.live.clue.service.api.remoteservice.conf.mall.salegoods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.mall.salegoods.MallSaleSpuExtDto;

import java.util.List;
import java.util.Map;

/**
 * @author xuzhigang
 * @date 2023/5/8 19:24
 **/
@AdvancedFeignClient
public interface RemoteMallSaleSpuExtService {

    /**
     * 根据spuId和confName查询
     *
     * @param spuId    商品id
     * @param confName {@link cn.com.duiba.live.clue.service.api.enums.conf.mall.salegoods.MallSaleSpuExtEnum}
     * @return 商品扩展
     */
    String selectValueBySpuIdAndConfName(Long spuId, Integer confName);

    /**
     * 根据spuId和confName查询
     *
     * @param spuId    商品id
     * @param confNames {@link cn.com.duiba.live.clue.service.api.enums.conf.mall.salegoods.MallSaleSpuExtEnum}
     * @return 商品扩展 key: confName value: 商品扩展值
     */
    Map<Integer, String> getMapBySpuIdAndConfNames(Long spuId, List<Integer> confNames);

    /**
     * 新增/更新
     * @param dto 商品扩展
     * @return 执行结果
     */
    int insertOrUpdate(MallSaleSpuExtDto dto);
}
