package cn.com.duiba.live.clue.service.api.remoteservice.conf.mall.salegoods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.mall.salegoods.MallSaleSpuDto;
import cn.com.duiba.live.clue.service.api.param.conf.mall.goods.MallGoodsSpuPageParam;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2022/8/11 7:49 下午
 **/
@AdvancedFeignClient
public interface RemoteMallSaleSpuService {

    /**
     * 根据spuId查询
     * @param spuId spuId
     * @return 商城-售卖商品
     */
    MallSaleSpuDto selectBySpuId(Long spuId);

    /**
     * 根据spuId查询，包含已删除的
     * @param spuId spuId
     * @return 商城-售卖商品
     */
    MallSaleSpuDto selectByIdContainsDeleted(Long spuId);


    /**
     * 根据业务类型业务id批量查询
     *
     * @param param 查询参数
     * @return 商城-售卖商品集合
     */
    List<MallSaleSpuDto> selectByBiz(MallGoodsSpuPageParam param);

    /**
     * 根据业务类型业务id查询数量
     * @param param 查询参数
     * @return 数量
     */
    Long selectCountByBizParam(MallGoodsSpuPageParam param);

    /**
     * 根据业务类型业务id批量查询
     *
     * @param bizId 业务id
     * @param bizTypes 业务类型
     * @return 商城-售卖商品集合
     */
    List<MallSaleSpuDto> selectByBizTypes(Long bizId, List<Integer> bizTypes);

    /**
     * 根据业务类型业务id批量查询
     *
     * @param bizId 业务id
     * @param bizType 业务类型
     * @return 商城-售卖商品集合-数量
     * @deprecated {@link #selectCountByBizParam(MallGoodsSpuPageParam)}
     */
    @Deprecated
    Long selectCountByBiz(Long bizId, Integer bizType);


    /**
     * 根据spuId批量查询
     * @param spuIdList spuId
     * @return 商城-售卖商品
     */
    List<MallSaleSpuDto> selectBySpuIdList(List<Long> spuIdList);

    /**
     * 批量插入 - 用于管理后台
     *
     * @param dtoList 售卖商品-spuList
     * @return List<Long>
     */
    List<MallSaleSpuDto> batchInsert(List<MallSaleSpuDto> dtoList);

    /**
     * 根据商品库商品id查询
     *
     * @param goodsId 商品id
     * @return {@link List}<{@link MallSaleSpuDto}>
     */
    List<MallSaleSpuDto> selectByGoodsIdList(Long goodsId);

    /**
     * 插入商品
     *
     * @param spuDto spu 售卖商品-spu
     * @return true-插入成功 false-插入失败
     */
    boolean insert(MallSaleSpuDto spuDto);

    /**
     * 更新商品
     *
     * @param spuDto 商品
     * @return true-更新成功 false-更新失败
     */
    boolean update(MallSaleSpuDto spuDto);

    /**
     * 按照业务属性删除spu
     *
     * @param bizId 业务id
     * @param bizType 业务类型
     * @param spuIdList 选填
     * @return true-更新成功 false-更新失败
     */
    boolean deleteByBizIdBizType(Long bizId,Integer bizType,List<Long> spuIdList);

    /**
     * 逻辑删除spu
     *
     * @param id id
     * @return true-更新成功 false-更新失败
     */
    boolean deleteLogic(Long id);


    /**
     * 置顶
     * @param spuId 商品id
     * @return 结果
     */
    boolean top(Long spuId);


}
