package cn.com.duiba.live.clue.service.api.remoteservice.conf.mall.sku;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.mall.sku.MallGoodsSkuDto;

import java.util.List;

/**
 * 商城-规格库存单元
 *
 * @author kjj mybatis generator
 * @date 2022-07-27
 */
@AdvancedFeignClient
public interface RemoteMallGoodsSkuService {

    /**
     * 查询指定商品的sku信息
     *
     * @param bizType 业务类型
     * @param bizId   业务id
     * @return 商城-规格库存单元集合
     */
    List<MallGoodsSkuDto> listByBiz(Integer bizType, Long bizId);

    /**
     * 批量查询商品的sku信息
     *
     * @param bizType 业务类型 {@link cn.com.duiba.live.clue.service.api.enums.conf.mall.sku.SkuBizTypeEnum}
     * @param bizIds  业务id集合
     * @return 商城-规格库存单元集合
     */
    List<MallGoodsSkuDto> listByBizIds(Integer bizType, List<Long> bizIds);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 商城-规格库存单元
     */
    MallGoodsSkuDto selectById(Long id);

    /**
     * 批量根据主键查询
     *
     * @param ids 主键集合
     * @return 商城-规格库存单元
     */
    List<MallGoodsSkuDto> listByIds(List<Long> ids);


    /**
     * 通过sku编码和供应商id查询
     *
     * @param supplierId 供应商id
     * @param skuCode    sku码
     * @return {@link List}<{@link MallGoodsSkuDto}> 商城-规格库存单元
     */
    List<MallGoodsSkuDto> listBySupplierSkuCode(Long supplierId, List<String> skuCode, Integer bizType);

    /**
     * 新增
     *
     * @param dto 商城-规格库存单元
     * @return 执行结果
     */
    boolean insert(MallGoodsSkuDto dto);

    /**
     * 新增
     *
     * @param list 商城-规格库存单元
     * @return 执行结果
     */
    boolean batchInsert(List<MallGoodsSkuDto> list);

    /**
     * 更新
     *
     * @param dto 商城-规格库存单元
     * @return 执行结果
     */
    boolean update(MallGoodsSkuDto dto);

    /**
     * 批量更新
     *
     * @param dtos 商城-规格库存单元
     * @return 执行结果
     */
    boolean batchUpdate(List<MallGoodsSkuDto> dtos);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    boolean delete(Long id);

    /**
     * 物理删除
     *
     * @param ids 主键
     * @return 执行结果
     */
    boolean batchDelete(List<Long> ids);

    /**
     * 根据业务id批量删除
     *
     * @param bizIds  业务id集合
     * @param bizType 业务类型
     * @return 删除结果
     */
    boolean deleteByBizIds(List<Long> bizIds, Integer bizType);

    /**
     *  根据供应商id批量查询
     * @param supplierIds 供应商id集合
     * @param bizType 商业类型
     * @return {@link List}<{@link MallGoodsSkuDto}>
     */
    List<MallGoodsSkuDto> listBySupplierIds(List<Long> supplierIds, Integer bizType);



}