package cn.com.duiba.live.clue.service.api.remoteservice.conf.mall.supplier;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.bean.conf.mall.supplier.MallSupplerIdNameBean;
import cn.com.duiba.live.clue.service.api.dto.conf.mall.supplier.MallSupplierDto;

import java.util.List;

/**
 * 商城-供应商
 *
 * @author kjj mybatis generator 
 * @date 2022-07-27
 */
@AdvancedFeignClient
public interface RemoteMallSupplierService {
     
    /**
     * 查询所有
     *
     * @return 商城-供应商集合
     */
    List<MallSupplierDto> listAll();

    /**
     * 分页查询
     *
     * @param offset  偏移量
     * @param pageSize 分页大小
     * @return 分页列表
     */
    List<MallSupplierDto> pageList(Integer offset, Integer pageSize);

    /**
     * 统计记录数
     *
     * @return 记录数
     */
    Long countAll();

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 商城-供应商
     */
    MallSupplierDto selectById(Long id);

    /**
     * 根据主键集合批量查询
     *
     * @param ids 主键集合
     * @return 供应商集合
     */
    List<MallSupplierDto> listByIds(List<Long> ids);

    /**
     * 根据供应商名称集合批量查询
     *
     * @param nameList 主键集合
     * @return 供应商集合
     */
    List<MallSupplerIdNameBean> listByNames(List<String> nameList);

    /**
     * 新增
     *
     * @param dto 商城-供应商
     * @return 执行结果
     */
    boolean insert(MallSupplierDto dto);

    /**
     * 更新
     * @param dto 商城-供应商
     * @return 执行结果
     */
    boolean update(MallSupplierDto dto);

    /**
     * 软删
     *
     * @param id 主键
     * @return 执行结果
     */
    boolean delete(Long id);
}