package cn.com.duiba.live.clue.service.api.remoteservice.conf.potential;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.potential.LivePotentialDialogueTemplateConfDetailDto;

import java.util.List;

/**
 * 准客户话术模版配置
 *
 * @author ZhangJun
 * @date 2021/8/19 6:56 下午
 */
@AdvancedFeignClient
public interface RemoteLivePotentialDialogueTemplateService {

    /**
     * 查询指定直播间的话术模版配置详情<br/>
     * <ol>
     *     <li>查询基础话术模版</li>
     *     <li>查询话术模版关联的承诺卡片</li>
     *     <li>查询话术模版关联的问题</li>
     *     <li>组装话术模版详情返回</li>
     * </ol>
     *
     * @param liveId 直播id
     * @return 话术模版
     */
    List<LivePotentialDialogueTemplateConfDetailDto> selectByLiveId(Long liveId);

    /**
     * 批量保存直播话术模版详情<br/>
     * <ol>
     *     <li>查询是否存在老数据</li>
     *     <li>清理老数据
     *         <ol>
     *             <li>清理老的问题</li>
     *             <li>清理老的承诺卡片</li>
     *             <li>清理老的话术模版</li>
     *         </ol>
     *     </li>
     *     <li>保存新数据
     *         <ol>
     *             <li>保存承诺卡片</li>
     *             <li>保存关联承诺卡片的基础话术模版</li>
     *             <li>保存关联话术模版的问题</li>
     *         </ol>
     *     </li>
     * </ol>
     *
     * @param liveId 直播id
     * @param dtos 话术模版集合
     * @return 保存结果
     */
    boolean batchSaveDialogue(Long liveId, List<LivePotentialDialogueTemplateConfDetailDto> dtos);

    /**
     * 根据直播id + 人脉类型查询指定直播间的话术模版配置详情
     * <ol>
     *     <li>查询基础话术模版</li>
     *     <li>查询话术模版关联的承诺卡片</li>
     *     <li>查询话术模版关联的问题</li>
     *     <li>组装话术模版详情返回</li>
     * </ol>
     *
     * @param liveId 直播id
     * @param inviteType 人脉邀请类型{@link cn.com.duiba.live.clue.service.api.enums.conf.potential.AgentDirectlyEnum}
     * @return 话术模版
     */
    LivePotentialDialogueTemplateConfDetailDto selectByLiveIdAndInviteType(Long liveId, int inviteType);

}
