package cn.com.duiba.live.clue.service.api.remoteservice.conf.pre;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.pre.LivePreGoldenEggConfDto;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2022/12/8 10:40 上午
 **/
@AdvancedFeignClient
public interface RemoteLivePreGoldenEggConfService {
    /**
     * 根据直播id和用户持卡身份查询配置
     *
     * @param liveId 直播id
     * @param userCardRole 用户持卡身份 {@link cn.com.duiba.live.clue.service.api.enums.conf.LiveUserCardRoleEnum}
     * @return 预告页用户身份-砸金蛋弹窗配置集合
     */
    List<LivePreGoldenEggConfDto> selectByLiveIdAndRole(Long liveId, Integer userCardRole);

    /**
     * 根据直播id查询配置
     *
     * @param liveId 直播id
     * @return 预告页用户身份-砸金蛋弹窗配置集合
     */
    List<LivePreGoldenEggConfDto> selectByLiveId(Long liveId);

    /**
     * 批量保存
     *
     * @param list 预告页用户身份-砸金蛋弹窗配置
     * @return 执行结果
     */
    int batchInsert(List<LivePreGoldenEggConfDto> list);

    /**
     * 新增
     * @param dto 预告页用户身份-砸金蛋弹窗配置
     * @return 执行结果
     */
    int insert(LivePreGoldenEggConfDto dto);

    /**
     * 批量更新
     * @param list 预告页用户身份-砸金蛋弹窗配置
     * @return 执行结果
     */
    int batchUpdate(List<LivePreGoldenEggConfDto> list);

    /**
     * 更新
     * @param dto 预告页用户身份-砸金蛋弹窗配置
     * @return 执行结果
     */
    int update(LivePreGoldenEggConfDto dto);
}
