package cn.com.duiba.live.clue.service.api.remoteservice.conf.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.guess.LiveConfRedGuessDto;
import cn.com.duiba.live.clue.service.api.dto.conf.guess.LiveConfRedGuessListDto;
import cn.com.duiba.live.clue.service.api.dto.conf.guess.LiveLatestGuessRedRedisDto;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-05-11 16:54
 * 猜数红包rpc服务service
 */
@AdvancedFeignClient
public interface RemoteLiveRedGuessApiService {

    /**
     * 猜数红包列表页
     * @param liveId 直播id
     * @return 猜数红包列表页
     */
    List<LiveConfRedGuessListDto> listByLiveId(Long liveId);

    /**
     * 根据配置id获取猜数红包详情
     * @param confId 红包配置id
     * @return 猜数红包
     */
    LiveConfRedGuessDto findByConfId(Long confId);

    /**
     * 从redis中获取最新一轮的红包信息
     * @param liveId 直播id
     * @return 红包信息
     */
    LiveLatestGuessRedRedisDto findLatestFromRedis(Long liveId);

    /**
     * 获取上一轮红包结束时间
     * @param liveId 直播id
     * @return 上一轮红包结束时间
     */
    Long getLastEndTime(Long liveId);

    /**
     * 新增或保存猜数红包
     * @param dto 猜数红包信息
     * @return 操作结果
     */
    boolean saveOrUpdate(LiveConfRedGuessDto dto);

    /**
     * 逻辑删除猜数红包
     * @param confId 红包配置id
     * @return 操作结果
     */
    boolean logicDeletedByConfId(Long confId);

    /**
     * 发放红包
     * @param confId 红包id
     * @return 操作结果
     */
    boolean openRed(Long confId);

    /**
     * 结束红包
     * @param confId 红包id
     * @return 操作结果
     */
    boolean closeRed(Long confId);

    /**
     * 逻辑删除直播间所有猜数红包
     * @param liveId 直播id
     * @return 删除结果
     */
    boolean logicDeletedByLiveId(Long liveId);

}
