package cn.com.duiba.live.clue.service.api.remoteservice.conf.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.red.LiveRedPacketConfExtDto;

import java.util.List;
import java.util.Map;

/**
 * 直播红包配置拓展信息
 *
 * @author 吴文哲
 * @date 2021/6/11 3:01 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveRedPacketConfExtService {

    /**
     * 根据红包配置id + 配置名称 查询直播红包配置拓展信息
     *
     * @param redConfId 红包配置id
     * @param confName  红包配置名称
     * @return 红包配置拓展信息
     * @see cn.com.duiba.live.clue.service.api.enums.conf.red.LiveRedPackConfExtEnum
     */
    LiveRedPacketConfExtDto selectByRedConfIdAndConfNameFromRedis(Long redConfId, Integer confName);

    /**
     * 根据直播间id + 配置名称 查询直播红包配置拓展信息
     *
     * @param liveId 直播间id
     * @param confName  红包配置名称
     * @return 红包配置拓展信息列表
     * @see cn.com.duiba.live.clue.service.api.enums.conf.red.LiveRedPackConfExtEnum
     */
    List<LiveRedPacketConfExtDto> selectByLiveIdAndConfName(Long liveId, Integer confName);

    /**
     * 新增/修改
     * @param confExtDto 配置信息
     * @return 影响行数
     */
    int saveConfExt(LiveRedPacketConfExtDto confExtDto);

    /**
     * 根据红包配置id查询
     * @param redPacketId id
     * @return 结果
     */
    List<LiveRedPacketConfExtDto> selectByRedPacketId(Long redPacketId);

    /**
     * 批量新增或修改
     * @param map key：配置键 value：配置值
     * @param liveId 直播id
     * @param redPacketId 红包id
     * @return 新增修改结果
     */
    int batchSaveOrUpdate(Map<Integer, String> map, Long liveId, Long redPacketId);
}
