package cn.com.duiba.live.clue.service.api.remoteservice.conf.resource;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.resource.FormResourceDto;
import cn.com.duiba.live.clue.service.api.dto.conf.resource.ResourceDto;
import cn.com.duiba.live.clue.service.api.dto.conf.resource.ResourceTestDto;
import cn.com.duiba.live.clue.service.api.param.conf.resource.ResourceSearchParam;
import cn.com.duiba.live.clue.service.api.param.conf.resource.ResourceTestSaveParam;

import java.util.List;
import java.util.Map;

/**
 * 资源服务类
 * @author 吴文哲
 * @date 2020-04-01 13:57
 **/
@AdvancedFeignClient
public interface RemoteResourceApiService {

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播资料库集合
     */
    List<ResourceDto> findPage(ResourceSearchParam param);

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 直播资料库集合
     */
    List<ResourceDto> findList(ResourceSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long findCount(ResourceSearchParam param);

    /**
     * 新增/修改资源
     * @param dto
     * @return
     */
    Long saveResource(ResourceDto dto);


    /**
     * 根据主键逻辑删除
     * @param id
     * @return
     */
    Integer delById(Long id);


    /**
     * 根据主键查询
     * @param id
     * @return
     */
    ResourceDto findById(Long id);

    /**
     * 根据主键查询
     * @param ids
     * @return
     */
    List<ResourceDto> findByIds(List<Long> ids);

    /**
     * 保存/修改表单资料
     *
     * @param dto 表单资料
     * @return true-成功 false-失败
     */
    Long saveFormResource(FormResourceDto dto);

    /**
     * 查询资源标题
     * @param ids 资源id集合
     * @return key：资源id value：资源标题
     */
    Map<Long, String> findTitleMap(List<Long> ids);

    /**
     * 保存/修改测试类型资料
     *
     * @param param 测试类型资料
     * @return tb_resource主键ID
     */
    Long saveTestResource(ResourceTestSaveParam param);

    /**
     * 根据tb_resource表主键ID查询
     * @param resourceId
     * @return 测试类型资料信息
     */
    ResourceTestDto findTestResource(Long resourceId);
}
