package cn.com.duiba.live.clue.service.api.remoteservice.conf.reward;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.reward.LiveAgentInviteRewardDto;

/**
 * @author zhuenhui
 * @date 2021/09/02 10:11 上午
 * @description 代理人邀约红包 - RPC服务
 */
@AdvancedFeignClient
public interface RemoteLiveAgentInviteRewardApiService {

    /**
     * 根据直播id获取配置详情 (先走Redis, 再走DB)
     *
     * @param liveId 直播Id
     * @return 配置详情
     */
    LiveAgentInviteRewardDto findByLiveIdWithCache(Long liveId);

    /**
     * 切换配置状态
     *
     * @param liveId 直播Id
     * @param status 状态
     *               {@link cn.com.duiba.live.clue.service.api.enums.conf.common.CommonConfigSwitchEnum}
     * @return 执行结果
     */
    boolean switchStatus(Long liveId, Integer status);

    /**
     * 保存 / 更新邀约红包配置
     *
     * @param dto 配置详情
     * @return 执行结果
     */
    boolean saveOrUpdate(LiveAgentInviteRewardDto dto);
}
