package cn.com.duiba.live.clue.service.api.remoteservice.conf.sign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.sign.LiveIncrStaffSignConfigDto;
import cn.com.duiba.live.clue.service.api.param.common.PageQuery;

import java.util.List;

/**
 * @author linjianhui
 * @date 2021/3/28 00:50
 * @Description 直播增员签到配置
 */
@AdvancedFeignClient
public interface RemoteLiveIncrStaffSignConfigService {

    /**
     * 新增直播增员签到配置
     * @param dto 签到配置
     * @return 配置对应主键id
     */
    Long insert(LiveIncrStaffSignConfigDto dto);

    /**
     * 编辑直播增员签到配置
     * @param dto 签到配置
     * @return 变更的条数
     */
    int update(LiveIncrStaffSignConfigDto dto);

    /**
     * 通过主键id查询签到配置
     * @param id 主键id
     * @return 签到配置
     */
    LiveIncrStaffSignConfigDto findById(Long id);

    /**
     * 分页查询直播增员签到配置表
     * 管理端专用
     * @param liveId 直播公司id 可为null
     * @param pageQuery 分页
     * @return 签到配置列表
     */
    List<LiveIncrStaffSignConfigDto> selectListByIdOrTitle(Long liveId, PageQuery pageQuery);

    /**
     * 查询直播增员签到配置表总条数
     * 管理端专用
     * @param liveId 直播公司id 可为null
     * @return 总条数
     */
    Long selectCount(Long liveId);
}
