package cn.com.duiba.live.clue.service.api.remoteservice.conf.survey;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.survey.reward.LiveSurveyRewardDto;
import cn.com.duiba.live.clue.service.api.param.conf.survey.reward.LiveSurveyRewardSaveOrUpdateParam;

/**
 * 直播问卷有奖
 * @author lizhi
 * @date 2021/12/14 3:57 下午
 */
@AdvancedFeignClient
public interface RemoteLiveSurveyRewardService {

    /**
     * 根据直播ID查询（走redis缓存）
     * @param liveId 直播ID
     * @return 问卷有奖配置
     */
    LiveSurveyRewardDto selectByLiveIdCache(Long liveId);

    /**
     * 根据直播ID查询剩余奖品份数（直接查询redis）
     * @param liveId 直播ID
     * @return 剩余奖品份数
     */
    int selectSurplusNum(Long liveId);

    /**
     * 新增或更新
     * @param liveId 直播ID
     * @param param 问卷有奖配置信息
     * @return 执行结果
     */
    int saveOrUpdate(Long liveId, LiveSurveyRewardSaveOrUpdateParam param);

    /**
     * 开启问卷有奖
     * @param liveId 直播ID
     * @return 执行结果
     */
    int open(Long liveId);

    /**
     * 关闭问卷有奖
     * @param liveId 直播ID
     * @return 执行结果
     */
    int close(Long liveId);

    /**
     * 异步扣减DB库存
     * @param liveId 直播ID
     * @param needNum 需要扣减的数量
     */
    void asyncDecrDbStock(Long liveId, int needNum);
}
