package cn.com.duiba.live.clue.service.api.remoteservice.conf.treasure;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.treasure.LiveTreasureConfDetailDto;
import cn.com.duiba.live.clue.service.api.dto.conf.treasure.LiveTreasureConfDto;
import cn.com.duiba.live.clue.service.api.dto.conf.treasure.redis.LiveTreasureRedisDto;

import java.util.List;

/**
 * 直播前宝箱rpc接口
 *
 * @author 吴文哲
 * @date 2021/4/9 10:01 上午
 **/
@AdvancedFeignClient
public interface RemoteLiveTreasureApiService {

    /**
     * 初始化停留时长宝箱
     *
     * @param liveTreasureConfDetailDto 停留时长宝箱列表
     * @return 操作结果
     */
    List<Long> initTimeTreasure(List<LiveTreasureConfDetailDto> liveTreasureConfDetailDto);

    /**
     * 新增宝箱配置
     * 使用数据库事务保证数据一致性
     *
     * @param dto 保存对象
     * @return 新增结果
     */
    Long insertLiveTreasureConf(LiveTreasureConfDetailDto dto);

    /**
     * 修改直播前宝箱配置
     * 使用数据库事务保证数据一致性
     *
     * @param dto 保存对象
     * @return 修改结果
     */
    boolean updateLiveTreasureConf(LiveTreasureConfDetailDto dto);

    /**
     * 开启 / 关闭宝箱
     *
     * @param treasureConfId     宝箱配置Id
     * @param treasureConfStatus 宝箱状态
     * @return 执行结果
     * @see cn.com.duiba.live.clue.service.api.enums.conf.treasure.TreasureConfStatusEnum
     */
    boolean switchStatus(Long treasureConfId, Integer treasureConfStatus);

    /**
     * 根据主键 查询宝箱配置
     *
     * @param id 主键
     * @return 直播前宝箱配置信息
     */
    LiveTreasureConfDto getTreasureConfById(Long id);

    /**
     * 根据直播间id和场景类型 查询宝箱配置
     *
     * @param liveId            直播间id
     * @param treasureSceneType 宝箱场景类型
     * @return 宝箱配置信息
     * @see cn.com.duiba.live.clue.service.api.enums.conf.treasure.TreasureSceneTypeEnum
     */
    List<LiveTreasureConfDto> listConfByLidAndType(Long liveId, Integer treasureSceneType);

    /**
     * 查询宝箱配置（走Redis）
     *
     * @param treasureConfId 宝箱配置Id
     * @return 宝箱配置
     */
    LiveTreasureRedisDto getLiveTreasureRedisDto(Long treasureConfId);

    /**
     * 查询宝箱配置（走Redis）
     *
     * @param liveId            直播间Id
     * @param treasureSceneType 宝箱场景类型
     * @return 宝箱配置集合
     */
    List<LiveTreasureRedisDto> listLiveTreasureRedisDto(Long liveId, Integer treasureSceneType);

}
