package cn.com.duiba.live.clue.service.api.remoteservice.conf.treasure;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.bean.conf.treasure.LiveTreasureTeamAwardBean;

import java.util.List;
import java.util.Map;

/**
 * @author zhuenhui
 * @date 2021/06/02 2:15 下午
 * @description 直播宝箱-团队奖励配置RPC服务
 */
@AdvancedFeignClient
public interface RemoteLiveTreasureTeamAwardService {

    /**
     * 根据宝箱ID查询团队奖励Id列表
     *
     * @param treasureConfId 宝箱ID
     * @return 团队奖励Id
     */
    List<Long> listTeamAwardId(Long treasureConfId);

    /**
     * 删除团队奖励配置
     *
     * @param teamAwardIds 团队奖励配置Id列表
     * @return 执行结果
     */
    int batchDeleteTeamAward(List<Long> teamAwardIds);

    /**
     * 新增团队奖励配置
     *
     * @param treasureConfId   宝箱配置Id
     * @param teamAwardDtoList 团队奖励配置列表
     * @return 执行结果
     */
    int batchInsertTeamAward(Long treasureConfId, List<LiveTreasureTeamAwardBean> teamAwardDtoList);

    /**
     * 获取宝箱配置对应的团队奖励总份数
     *
     * @param treasureConfId 宝箱配置Id
     * @return 团队奖励总份数
     */
    int getTeamAwardTotalNum(Long treasureConfId);

    /**
     * 查询团队奖励配置Map，K：teamId V：interactConfId
     *
     * @param treasureConfId 宝箱配置Id
     * @return kvMap
     */
    Map<Long, Long> findLiveTreasureTeamAwardMap(Long treasureConfId);

}
