package cn.com.duiba.live.clue.service.api.remoteservice.conf.voucher;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.vocher.LiveVoucherConfExtDto;
import cn.com.duiba.live.clue.service.api.param.conf.voucher.VoucherSaveParam;

import java.util.List;
import java.util.Map;

/**
 * @author dugq
 * @date 2022/1/25 11:32 上午
 */
@AdvancedFeignClient
public interface RemoteVoucherConfService {


    /**
     * 直播间是否开启直播秒杀代金券
     * @param liveId 直播ID
     * @return 是否开启
     */
    boolean isOpenVoucher(Long liveId);

    /**
     * 修改直播见是否开启直播秒杀代金券
     * @param liveId 直播ID
     * @param isOpen 是否开启
     * @return 返回是否修改成功
     */
    boolean modifyVoucherState(Long liveId,boolean isOpen);

    /**
     * 保存直播间秒杀代金券配置
     * @param param 保存参数
     * @return 配置ID null:保存失败
     */
    Long saveVoucher(VoucherSaveParam param);

    /**
     * 根据直播ID查询秒杀代金券配置详情
     * 附带redis缓存
     * @param liveId 直播ID
     * @return 直播间秒杀代金券配置详情
     */
    LiveVoucherConfExtDto getVoucherConf(Long liveId);

    /**
     * 判断直播间是否可以开启秒杀代金券
     * @param liveId 直播间ID
     * @return 是否可以开启
     */
    boolean canOpenVoucher(Long liveId);

    /**
     * 根据直播id批量查询代金券信息
     *
     * @param liveIds 直播id集合
     * @return 代金券信息 key: liveId value: 代金券id
     */
    Map<Long, Long> getLiveId2VoucherIdMapByLiveIds(List<Long> liveIds);
}
