package cn.com.duiba.live.clue.service.api.remoteservice.mall.group;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.mall.group.MallGroupRecordDetailDto;

import java.util.List;
import java.util.Map;

/**
 * @author xuzhigang
 * @date 2023/5/10 19:13
 **/
@AdvancedFeignClient
public interface RemoteMallGroupRecordDetailService {
    /**
     * 根据用户id和订单id查询拼团明细
     *
     * @param liveUserId 直播用户id
     * @param orderId 订单id
     * @return 拼团明细
     */
    MallGroupRecordDetailDto selectByLiveUserIdAndOrderId(Long liveUserId, Long orderId);

    /**
     * 批量查询
     *
     * @param liveUserId 用户id
     * @param orderIds 订单id集合
     * @return 拼团明细
     */
    List<MallGroupRecordDetailDto> selectListByLiveUserIdAndOrderIds(Long liveUserId, List<Long> orderIds);

    /**
     * 根据用户id和拼团记录id查询拼团明细
     *
     * @param liveUserId 直播用户id
     * @param groupRecordId 拼团记录id
     * @return 拼团明细
     */
    MallGroupRecordDetailDto selectByLiveUserIdAndRecordId(Long liveUserId, Long groupRecordId);

    /**
     * 更新拼团明细
     *
     * @param dto 拼团明细
     * @return 执行结果
     */
    int update(MallGroupRecordDetailDto dto);

    /**
     * 新增拼团明细
     * @param dto 拼团明细
     * @return 执行结果
     */
    int insert(MallGroupRecordDetailDto dto);

    /**
     * 查询最低拼团价
     *
     * @param recordId 拼团记录id
     * @return 拼团价
     */
    Integer selectMinGroupPrice(Long recordId);

    /**
     * 根据直播用户id批量查询参与次数
     *
     * @param liveUserIds 直播用户id
     * @return key: 用户id value: 参与次数
     */
    Map<Long, Long> getJoinedTimesByLiveUserIds(List<Long> liveUserIds);

    /**
     * 根据拼团记录id查询明细
     *
     * @param groupRecordId 拼团记录id
     * @return 明细
     */
    List<MallGroupRecordDetailDto> selectByGroupRecordId(Long groupRecordId);

    /**
     * 拼团过期
     *
     * @param ids 主键id集合
     * @return 执行结果
     */
    Map<Long, Boolean> batchExpire(List<Long> ids);

    /**
     * 拼团取消
     *
     * @param ids 主键id集合
     * @return 执行结果
     */
    Map<Long, Boolean> batchCancel(List<Long> ids);

    /**
     * 拼团成功
     *
     * @param ids 主键id集合
     * @return 执行结果
     */
    Map<Long, Boolean> batchSuccess(List<Long> ids);
}
