package cn.com.duiba.live.clue.service.api.remoteservice.mall.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.mall.user.MallUserRealInfoDto;

/**
 * @author xuzhigang
 * @date 2023/6/27 16:34
 **/
@AdvancedFeignClient
public interface RemoteMallUserRealInfoService {

    /**
     * 根据直播用户id批量查询 redis缓存
     *
     * @param liveUserId 直播用户id
     * @return 实名信息
     */
    MallUserRealInfoDto selectByLiveUserIdWithCache(Long liveUserId);

    /**
     * 更新实名信息
     *
     * @param dto 实名信息
     * @return 执行结果
     */
    int update(MallUserRealInfoDto dto);

    /**
     * 新增实名信息
     *
     * @param dto 实名信息
     * @return 执行结果
     */
    int insert(MallUserRealInfoDto dto);
}
