package cn.com.duiba.live.clue.service.api.util;

import org.apache.commons.lang3.StringUtils;

/**
 * Created with duiba.
 * User: zhouzhou
 * Date: 2020/3/24 0024 Time: 15:53
 * <p>
 * Description:字符串帮助类
 */
public class StringHelper {

    /**
     * 全部不为空
     * <p>
     *     "aaa", "   ","bbb" => false
     *     "aaa","bbb","ccc" => true
     * </p>
     * @param strings
     * @return
     */
    public static boolean isAllNotBlank(String ... strings){
        for (String string : strings) {
            if (StringUtils.isBlank(string)){
                return false;
            }
        }
        return true;
    }

    /**
     * 全部为空
     * <p>
     *     "aaa", "   ","bbb" => false
     *     "",""," " => false
     *     "","","" => true
     * </p>
     * @param strings
     * @return
     */
    public static boolean isAllBlank(String ... strings){
        for (String string : strings) {
            if (StringUtils.isNotEmpty(string)){
                return false;
            }
        }
        return true;
    }

}