package cn.com.duiba.live.normal.service.api.remoteservice.rewardSignRecord;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.lottery.LiveLotteryCodeDto;
import cn.com.duiba.live.normal.service.api.dto.lottery.LiveLotteryUserCodeDto;
import cn.com.duiba.live.normal.service.api.dto.rewardSignRecord.LiveRewardSignRecordDto;
import cn.com.duiba.live.normal.service.api.dto.rewardSignRecord.LiveRewardSignStatisticsDto;
import cn.com.duiba.live.normal.service.api.param.lottery.LiveLotteryCodeSearchParam;
import cn.com.duiba.live.normal.service.api.param.rewardSignRecord.LiveRewardSignRecordSearchParam;

import java.util.List;
import java.util.Map;

/**
 * 直播奖品签收记录
 *
 * @author xiaotian
 * @date 2021/01/26 8:51 PM
 */
@AdvancedFeignClient
public interface RemoteLiveRewardSignRecordApiService {

    /**
     * 根据条件查询，不分页
     * 手机端查询查询中奖页分页使用
     * @param param 查询条件
     * @return 直播抽奖码集合
     */
    List<LiveRewardSignRecordDto> selectList(LiveRewardSignRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * 手机端查询查询中奖页分页使用
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(LiveRewardSignRecordSearchParam param);

    /**
     * 根据liveUserId更新记录
     *
     * @return 抽奖码集合
     */
    boolean check(LiveRewardSignRecordDto liveRewardSignRecordDto);


    /**
     * 根据liveUserId更新记录
     *
     * @return 抽奖码集合
     */
    boolean sign(LiveRewardSignRecordDto liveRewardSignRecordDto);


    /**
     * 根据liveId和liveUserId 获取中奖记录
     * @param liveId
     * @param liveUserId
     * @return
     */
    LiveRewardSignRecordDto selectByLiveIdAndUserId(Long liveId,Long liveUserId);


    /**
     * 获取统计数量
     * @param liveId
     * @param agantId
     * @return
     */
    LiveRewardSignStatisticsDto  getStatistics(Long liveId,Long agantId);

}
