package cn.com.duiba.live.normal.service.api.remoteservice.spoke;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.spoke.LiveSpokeStoreDto;
import cn.com.duiba.live.normal.service.api.param.spoke.LiveSpokeStoreSearchParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

/**
 * 直播评论库
 * @author kjj mybatis generator 
 * @date 2021-02-23
 */
@AdvancedFeignClient
public interface RemoteLiveSpokeStoreService {

    /**
     * 从es搜索
     * @param param 搜索条件
     * @return left：符合条件的总数 value：当前页结果
     */
    Pair<Long, List<LiveSpokeStoreDto>> searchFromEs(LiveSpokeStoreSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播评论库
     */
    LiveSpokeStoreDto selectById(Long id);

    /**
     * 新增
     * @param dto 直播评论库
     * @return 执行结果
     */
    int insert(LiveSpokeStoreDto dto);

    /**
     * 更新
     * @param dto 直播评论库
     * @return 执行结果
     */
    int update(LiveSpokeStoreDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}