package cn.com.duiba.live.normal.service.api.dto.lottery;

import lombok.Data;

import java.util.List;

/**
 * @author dugq
 * @date 2021/3/1 7:36 下午
 */
@Data
public class InsertLotteryCodeDto {

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 互动类型：1-预约，2-签到, 3-关注直播间，4-累计观看，5-邀请好友
     * @see cn.com.duiba.live.normal.service.api.enums.lottery.LiveLotteryCodeSourceEnum
     */
    private Integer codeSource;

    /**
     * 被邀请人直播用户ID（仅在邀请好友抽奖码时可能有值）
     */
    private Long inviteeId;

    /**
     * 抽奖码对应的观看分钟，仅类型是累计观看时会有
     */
    private Integer watchDuration;

    /**
     * 本次发放的数量
     */
    private List<Long> ids;
}
