package cn.com.duiba.live.normal.service.api.remoteservice.videospecaward;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.videoSpecAward.VideoAgentSpecAwardDto;
import cn.com.duiba.live.normal.service.api.param.common.PageQuery;

import java.util.Date;
import java.util.List;

/**
 * 视频集锦指定中奖客户列表rpc接口
 * @author 吴文哲
 * @date 2021/1/25 7:07 下午
 **/
@AdvancedFeignClient
public interface RemoteVideoAgentSpecAwardApiService {


    /**
     * 根据配置id查询列表
     * @param confId 配置id
     * @return 代理人配置指定中奖列表
     */
    List<VideoAgentSpecAwardDto> selectByConfId(Long confId);

    /**
     * 视频代理人指定中奖列表
     * @param liveAgentId 直播代理人id
     * @param confId 直播视频指定中奖配置id
     * @param pageQuery 查询参数
     * @return 视频代理人指定中奖配置列表
     */
    List<VideoAgentSpecAwardDto> selectPageByAgentIdConfId(Long liveAgentId,Long confId, PageQuery pageQuery);

    /**
     * 根据配置id 被指定的用户id 删除记录
     * @param confId 配置id
     * @param liveUserId 被指定中奖的用户id
     * @return 影响行数
     */
    int delByConfIdAndLiveUserId(Long confId,Long liveUserId);

    /**
     * 更新中奖时间
     * @param id 主键id
     * @param receiveTime 中奖时间
     * @return 影响行数
     */
    int updateReceiveTime(Long id, Date receiveTime);

    /**
     * 更新中奖用户姓名
     * @param id 主键id
     * @param winnerName 中奖用户姓名
     * @return 影响行数
     */
    int updateWinnerName(Long id, String winnerName);

    /**
     * 根据代理人Id 视频配置id 统计客户数量
     * @param liveAgentId 代理人id
     * @param videoConfId 视频配置id
     * @param winnerStatus 访客领取状态
     * @see cn.com.duiba.live.normal.service.api.enums.specaward.VideoSpecAwardWinnerStatusEnums
     * @return 指定中奖客户数量
     */
    int countByAgentIdAndConfId(Long liveAgentId, Long videoConfId,Integer winnerStatus);

    /**
     * 保存直播精彩集锦 指定中奖客户列表
     * @param liveAgentId 直播代理人id
     * @param videoConfId 精彩集锦视频配置id
     * @param liveUserIds 指定中奖用户id列表
     * @return 影响行数
     */
    int saveVideoAgentSpecAward(Long liveAgentId, Long videoConfId, List<Long> liveUserIds);

    /**
     * 根据视频配置id + 直播用户id 查询列表
     * @param videoConfId 视频配置id
     * @param liveUserIds 直播用户id列表
     * @return 指定用户列表
     */
    List<VideoAgentSpecAwardDto> selectByConfIdAndUserIds(Long videoConfId, List<Long> liveUserIds);

    /**
     * 批量开奖
     * @param specAwardDtoIds tb_video_agent_spec_award.id
     * @return 影响行数
     */
    int batchOpenLottery(List<Long> specAwardDtoIds);

    /**
     * 批量标记为已观看
     * @param specAwardDtoIds tb_video_agent_spec_award.id
     * @return 影响行数
     */
    int batchMarkWatch(List<Long> specAwardDtoIds);

    /**
     * 根据条件分页查询 用户视频集锦指定中奖列表
     * @param liveUserId 直播用户id
     * @param winnerStatus 领取状态
     * @see cn.com.duiba.live.normal.service.api.enums.specaward.VideoSpecAwardWinnerStatusEnums
     * @param pageQuery 分页参数
     * @return 视频集锦用户指定中奖列表
     */
    List<VideoAgentSpecAwardDto> selectByLiveUserIdAndStatus(Long liveUserId, Integer winnerStatus, PageQuery pageQuery);
}
