package cn.com.duiba.live.normal.service.api.param.live;

import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 用户意见反馈
 * @author kjj mybatis generator 
 * @date 2020-10-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveUserFeedbackSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16027325248435403L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播userId
     */
    private Long liveVisitorId;

    /**
     * 直播ID，不填为0
     */
    private Long liveId;

    /**
     *  开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;


    /**
     * 处理状态 1:未处理，2:处理中，3:已处理，4:特殊处理
     * @see cn.com.duiba.live.normal.service.api.enums.live.feedback.FeedbackProcessStatusEnum
     */
    private Integer processStatus;
}