package cn.com.duiba.live.normal.service.api.remoteservice.rewardSignRecord;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.rewardSignRecord.LiveVisitorRewardRedDto;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2021/1/27 11:32
 */
@AdvancedFeignClient
public interface RemoteLiveRewardRedService {

    /**
     * 根据直播id和用户id查询
     * @param liveId 业务id
     * @param liveVisitorId 直播访客用户id
     * @return 直播访客奖品提交领取红包记录
     */
    @Deprecated
    LiveVisitorRewardRedDto selectByLiveAndVisitor(Long liveId, Long liveVisitorId);


    /**
     * 根据直播id和用户id查询
     * @param liveId 业务id
     * @param liveVisitorId 直播访客用户id
     * @param rewardType 1:确认红包 2：签收红包
     * @return 直播访客奖品提交领取红包记录
     */
    LiveVisitorRewardRedDto selectByLiveAndVisitorAndRewardType(Long liveId, Long liveVisitorId,Integer rewardType);

    /**
     * 新增
     * @param dto 直播访客奖品提交领取红包记录
     * @return 主键id
     */
    LiveVisitorRewardRedDto insert(LiveVisitorRewardRedDto dto);
}
