/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.normal.service.api.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LotteryCodeUtil {
    private static final Logger log = LoggerFactory.getLogger(LotteryCodeUtil.class);
    private static final Character[] PLACEHOLDERS = new Character[]{Character.valueOf('M'), Character.valueOf('F'), Character.valueOf('T'), Character.valueOf('A'), Character.valueOf('S'), Character.valueOf('X'), Character.valueOf('D'), Character.valueOf('P'), Character.valueOf('C'), Character.valueOf('I'), Character.valueOf('Y'), Character.valueOf('V'), Character.valueOf('N'), Character.valueOf('L'), Character.valueOf('J'), Character.valueOf('Q'), Character.valueOf('E'), Character.valueOf('U'), Character.valueOf('Z'), Character.valueOf('K'), Character.valueOf('R'), Character.valueOf('B'), Character.valueOf('H'), Character.valueOf('O'), Character.valueOf('W'), Character.valueOf('G')};
    private static final List<String> RANDOM_LIST;
    private static final Long MAX_LIVE_ID;
    private static final Long MAX_LOTTERY_CODE_ID;

    private LotteryCodeUtil() {
    }

    public static String encodeId2String(Long liveId, Long lotteryCodeId) {
        if (Objects.isNull(liveId) || Objects.isNull(lotteryCodeId)) {
            return null;
        }
        Pair<Character, Character> livePair = LotteryCodeUtil.getTwoCharByLiveId(liveId);
        Pair<String, String> codePair = LotteryCodeUtil.getDoubleFourByteNumById(lotteryCodeId);
        return livePair.getLeft() + (String)codePair.getLeft() + livePair.getRight() + (String)codePair.getRight();
    }

    private static Pair<Character, Character> getTwoCharByLiveId(long liveId) {
        if (liveId > MAX_LIVE_ID) {
            liveId %= MAX_LIVE_ID.longValue();
        }
        int first = (int)liveId % 25;
        int last = (int)liveId / 25;
        return ImmutablePair.of((Object)PLACEHOLDERS[first], (Object)PLACEHOLDERS[last]);
    }

    private static Pair<String, String> getDoubleFourByteNumById(long lotteryCodeId) {
        if (lotteryCodeId > MAX_LOTTERY_CODE_ID) {
            lotteryCodeId %= MAX_LOTTERY_CODE_ID.longValue();
        }
        long lowFourByte = lotteryCodeId % 10000L;
        long highFourByte = lotteryCodeId / 10000L;
        Pair<String, String> highPair = LotteryCodeUtil.getDoubleTwoCharByte(highFourByte);
        Pair<String, String> lowPair = LotteryCodeUtil.getDoubleTwoCharByte(lowFourByte);
        return ImmutablePair.of((Object)((String)lowPair.getLeft() + (String)highPair.getRight()), (Object)((String)lowPair.getRight() + (String)highPair.getLeft()));
    }

    private static Pair<String, String> getDoubleTwoCharByte(long sourceNum) {
        if (sourceNum >= 10000L) {
            sourceNum %= 10000L;
        }
        long lowTwoByte = sourceNum % 100L;
        long highTwoByte = sourceNum / 100L;
        return ImmutablePair.of((Object)RANDOM_LIST.get((int)highTwoByte), (Object)RANDOM_LIST.get((int)lowTwoByte));
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        HashMap<String, String> set = new HashMap<String, String>();
        for (long i = 0L; i < 1000000L; ++i) {
            for (long j = 1L; j < 10L; ++j) {
                String old = set.put(LotteryCodeUtil.encodeId2String(j, i), i + "-" + j);
                if (!Objects.nonNull(old)) continue;
                System.out.println(old + "==== " + i + "-" + j);
            }
        }
        long cost = System.currentTimeMillis() - start;
        System.out.println("cost ======= " + cost + "size=" + set.size());
    }

    static {
        MAX_LIVE_ID = 625L;
        MAX_LOTTERY_CODE_ID = 100000000L;
        String str = "99,30,74,75,35,17,67,43,01,62,03,66,84,79,26,39,97,52,25,87,55,60,05,44,90,70,63,06,13,11,28,83,72,82,32,37,64,14,10,57,40,00,45,81,96,42,09,19,04,23,18,12,16,47,02,91,80,36,76,29,48,24,56,33,92,78,50,41,07,31,34,21,89,86,08,73,22,69,51,98,27,88,68,94,71,38,85,49,15,93,54,77,61,53,95,46,20,58,59,65";
        String[] split = StringUtils.split((String)str, (String)",");
        RANDOM_LIST = Collections.unmodifiableList(Arrays.asList(split));
        str = null;
        Object var1_1 = null;
    }
}

