package cn.com.duiba.live.normal.service.api.enums.pointreward;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author wangbinbin
 * @create 2021-03-16 10:16
 * @descript 点对点推送买点
 */
@AllArgsConstructor
@Getter
public enum PointRewardPushTypeEnum {

    L35(1, "中奖结果通知", 224),
    L36(2, "提醒代理人设定中奖用户", 225),
    ;

    /**
     * 代码
     */
    private final Integer code;

    /**
     * 代码描述
     */
    private final String description;

    /**
     * 模版消息id
     */
    private final Integer markId;

    /**
     * 根据消息模版id查询推送代码
     */
    public static List<Integer> getCodesByMarks(List<Integer> marks) {
        if (CollectionUtils.isEmpty(marks)) {
            return Collections.emptyList();
        }
        return Arrays.stream(PointRewardPushTypeEnum.values()).filter(e -> marks.contains(e.markId))
                .map(PointRewardPushTypeEnum::getCode).collect(Collectors.toList());
    }
}
