package cn.com.duiba.live.normal.service.api.remoteservice.agent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.agent.LiveAgentSendRecordDto;

/**
 * 直播代理人赠送抽奖码记录
 * @author kjj mybatis generator 
 * @date 2021-03-18
 */
@AdvancedFeignClient
public interface RemoteLiveAgentSendRecordService {

    /**
     * 根据直播id查询是否有记录
     * @param liveId 主键
     * @return 直播代理人赠送抽奖码记录
     */
    LiveAgentSendRecordDto selectByLiveIdLimit1(Long liveId);

    /**
     * 根据直播id 代理人id 访客id查询
     *
     * @param liveId 直播id
     * @param agentId 代理人id
     * @param liveVisitorId 访客id
     * @return 赠送记录
     */
    LiveAgentSendRecordDto selectByLiveIdAgentIdVisitorId(Long liveId, Long agentId, Long liveVisitorId);

    /**
     * 新增
     * @param dto 直播代理人赠送抽奖码记录
     * @return 执行结果
     */
    int insert(LiveAgentSendRecordDto dto);
}