package cn.com.duiba.live.normal.service.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.clue.ClueVisitEnterDto;
import cn.com.duiba.live.normal.service.api.dto.clue.LiveClueVisitDto;
import cn.com.duiba.live.normal.service.api.dto.clue.LiveUserVisitDto;
import cn.com.duiba.live.normal.service.api.dto.clue.LiveUserVisitDurationDto;
import cn.com.duiba.live.normal.service.api.param.clue.LiveClueVisitSearchParam;
import cn.com.duiba.live.normal.service.api.param.clue.LiveVisitEnterOutParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 *
 * @author dugq
 * @date 2020-04-03
 */
@AdvancedFeignClient
public interface RemoteLiveClueVisitApiService {

    /**
     * 查询用户观看记录
     * @param param 查询条件
     * @return 观看记录
     */
    List<LiveClueVisitDto> selectList(LiveClueVisitSearchParam param);

    /**
     * 查询用户观看记录条数
     * @param param 查询条件
     * @return 观看记录条数
     */
    Long selectCount(LiveClueVisitSearchParam param);

    /**
     * 新增
     * @param dto 直播线索-观看记录
     * @return 执行结果
     */
    int insert(LiveClueVisitDto dto);

    /**
     * 更改
     * @param dto 直播线索-观看记录
     * @return 执行结果
     */
    int update(LiveClueVisitDto dto);

    /**
     * 用户退出直播间操作
     * @param param 用户信息
     * @return 操作条数
     */
    int outLive(LiveVisitEnterOutParam param);

    /**
     * 增加用户观看时长
     * @param liveId 直播ID
     * @param liveVisitorId 用户ID
     * @param addDuration 增加时长
     * @return 修改条数
     */
    int addDuration(Long liveId, Long liveVisitorId, Long addDuration);

    /**
     * 根据直播ID和访客ID观看访问记录
     * @param liveId 直播ID
     * @param liveVisitorId 访客ID
     * @return
     */
    LiveClueVisitDto selectByLiveIdAndVisitId(Long liveId, Long liveVisitorId);

    /**
     * 根据直播ID和访客ID观看访问记录
     * @param liveId 直播ID
     * @param liveVisitorId 访客ID
     * @return
     */
    List<ClueVisitEnterDto> selectVisitorIdsByLiveIdAndVisitIds(Long liveId, List<Long> liveVisitorId);

    /**
     * todo 瀑布流
     * 根据条件瀑布流查询直播访客记录
     * @param lastMaxId  上一次分页最大的主键id
     * @param pageSize  分页大小
     * @param liveId
     * @return
     */
    List<LiveUserVisitDto> findByCondition4Task(Long lastMaxId, int pageSize, Long liveId);

    /**
     * 根据访客ID和直播间ID查询观看时长
     * no cache
     * @param liveVisitorId
     * @param liveId
     * @return
     */
    Long findDuration(Long liveVisitorId, Long liveId);

    /**
     * 根据直播ID查询用户的在线时长
     * @param liveId
     * @param liveVisitorIds
     * @return
     */
    List<LiveUserVisitDurationDto> findLiveUsersDuration(Long liveId, List<Long> liveVisitorIds);

    /**
     * 批量查询用户观看时长
     * @param liveId 直播ID
     * @param liveVisitorIds 用户ID
     * @return key：用户ID，value：观看时长，单位秒
     */
    Map<Long, Integer> findUserDurationMap(Long liveId, List<Long> liveVisitorIds);

    /**
     * 查询直播ID对应观看人数
     * @param liveIdList 直播ID集合
     * @return key：直播ID，value：观看人数
     */
    Map<Long, Long> getLiveVisitorNum(List<Long> liveIdList);

    /**
     * !!!!!!!数据修复专用 其它地方慎用!!!!!
     * 更新访问线索数据
     * @param liveId 直播间id
     * @param visitorIds 访客id列表
     * @param agentId 代理人id
     * @return 影响行数
     */
    int updateAgentId4DataFix(Long liveId, List<Long> visitorIds, Long agentId);

    /**
     * !!!!!!!数据修复专用 其它地方慎用!!!!!
     * 删除访问线索数据
     * @param liveId 直播间id
     * @param currentAgentLiveUsersId 当前代理人的访客id
     * @return 影响行数
     */
    int deleteByLiveIdAndLiveUserId(Long liveId, Long currentAgentLiveUsersId);

    /**
     * 批量更新第一次到场时间,并把用户在线时长+1 避免3s内退出，没有一次心跳交互，展示为未到场
     * @param liveId 直播id
     * @param liveVisitorIds 直播用户id集合
     * @param time 时间
     * @return 执行结果
     */
    int batchUpdateFirstEnterTime(Long liveId, List<Long> liveVisitorIds, Date time);

    /**
     * 批量更新最近一次到场时间
     * @param liveId 直播id
     * @param liveVisitorIds 直播用户id集合
     * @param time 时间
     * @return 执行结果
     */
    int batchUpdateLastEnterTime(Long liveId, List<Long> liveVisitorIds, Date time);

    /**
     * 新增
     * @param list 直播线索-观看记录
     * @return 执行结果
     */
    int batchInsert(List<LiveClueVisitDto> list);

    /**
     * 批量增加增加用户观看时长
     * @param liveId 直播ID
     * @param liveVisitorIds 用户ID
     * @param addDuration 增加时长
     * @return 修改条数
     */
    int batchUpdateDuration(Long liveId, List<Long> liveVisitorIds, Long addDuration);

}
