package cn.com.duiba.live.normal.service.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.live.LiveVisitorQrcodeDto;

import java.util.List;
import java.util.Map;

/**
 * 访客二维码服务
 *
 * @author xuzhigang
 * @date 2020/9/18 4:18 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveVisitorQrcodeApiService {

    /**
     * 新增
     * @param dto 直播访客小程序二维码
     * @return 执行结果
     */
    int insert(LiveVisitorQrcodeDto dto);

    /**
     * 根据直播id和访客id查询小程序码id
     *
     * @param liveId 直播id
     * @param visitorId 访客id
     * @return 小程序码id
     */
    LiveVisitorQrcodeDto selectQrcodeIdByLiveVisitor(Long liveId, Long visitorId);

    /**
     * 根据直播id和访客用户id集合获取小程序链接
     * @param liveId 直播id
     * @param visitorIds 访客id集合
     * @return key：访客id value：小程序码链接
     */
    Map<Long, String> getQrCodeByLiveAndVisitors(Long liveId, List<Long> visitorIds);

    /**
     * 批量插入访客小程序码信息
     * @param list 小程序码信息集合
     * @return 插入行数
     */
    int batchInsert(List<LiveVisitorQrcodeDto> list);
}
