package cn.com.duiba.live.normal.service.api.remoteservice.lottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.lottery.LiveLotteryTaskRecordDto;
import cn.com.duiba.live.normal.service.api.dto.lottery.LiveLotteryVisitorDto;

import java.util.List;
import java.util.Set;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020-09-03 17:15
 */
@AdvancedFeignClient
public interface RemoteLiveLotteryTaskRecordApiService {

    /**
     * 获取有参与的用户id
     * @param liveId 直播id
     * @param confId 抽奖配置id
     * @param liveUserIds 直播用户id集合
     * @return 有参与的直播用户id
     */
    Set<Long> getHasJoinUserId(Long liveId, Long confId, Set<Long> liveUserIds);

    /**
     * 新增
     * @param list 直播抽奖任务记录
     * @return 执行结果
     */
    int batchInsert(List<LiveLotteryTaskRecordDto> list);

    /**
     * 获取最新参与的用户id
     * @param liveId 直播id
     * @param confId 抽奖配置id
     * @param pageSize 条数
     * @return 最新参与的用户id
     */
    Set<Long> getLastJoinUser(Long liveId, Long confId, Integer pageSize);

    /**
     * todo 瀑布流
     * 瀑布流方式查询用户id
     * @param liveId 直播id
     * @param confId 抽奖配置id
     * @param startId 开始id
     * @param pageSize 每页条数
     * @return 有参与的用户id信息
     */
    List<LiveLotteryVisitorDto> findByStartId(Long liveId, Long confId, Long startId, Integer pageSize);
}
