package cn.com.duiba.live.normal.service.api.remoteservice.pointreward;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.pointreward.RewardActivityDto;
import cn.com.duiba.live.normal.service.api.dto.pointreward.RewardActivityStatsDto;
import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import cn.com.duiba.live.normal.service.api.param.pointreward.RewardActivityAddParam;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2021-03-08 13:38
 * @descript 点对点活动remoteService
 */
@AdvancedFeignClient
public interface RemoteRewardActivityApiService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 查询结果
     */
    RewardActivityDto findById(Long id);

    /**
     * 根据主键列表查询
     * @param ids 主键列表
     * @return 查询结果
     */
    List<RewardActivityDto> findByIds(List<Long> ids);

    /**
     * 根据分页参数+活动类型查询
     * @param activityType 活动类型
     * @param liveUserId 用户id
     * @param activityStatus 活动状态
     * @param pageQuery 分页参数
     * @return 分页结果
     */
    List<RewardActivityDto> listActivity(Integer activityType, Long liveUserId, Integer activityStatus, PageQuery pageQuery);

    /**
     * 根据活动id获取活动统计数据
     * @param ids 活动id
     * @return 活动统计数据
     */
    List<RewardActivityStatsDto> listActivityStats(List<Long> ids);

    /**
     * 新增活动
     * @param param 活动新增参数
     * @return 活动新增结果
     */
    Long addActivity(RewardActivityAddParam param);

    /**
     * 更新剩余库存数
     * @param activityId 活动id
     * @param winnerNum 中奖人数
     * @return 执行结果
     */
    boolean updateAwardLeft(Long activityId, Integer winnerNum);

    /**
     * 更新活动的状态
     * @param activityIds 活动ids
     * @param status 修改的活动状态
     * @return 修改结果
     */
    Integer updateActivitiesStatus(List<Long> activityIds, Integer status);
}
