package cn.com.duiba.live.normal.service.api.dto.rewardSignRecord;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播奖品签收记录
 * @author kjj mybatis generator 
 * @date 2021-01-27
 */
@Data
public class LiveRewardSignRecordDto implements Serializable {
     
    private static final long serialVersionUID = 16117274456437056L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 代理人ID
     */
    private Long agentId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 奖励ID，对应tb_welfare.id集合，用,分开
     */
    private String rewardIds;

    /**
     * 中奖信息填写状态
     */
    private Integer winnerStatus;

    /**
     * 中奖填写的姓名
     */
    private String winnerName;

    /**
     * 签收状态， 0：未签收 1：已签收
     */
    private Integer signStatus;

    /**
     * 签收时间
     */
    private Date signTime;

    /**
     * 中奖时间
     */
    private Date winnerTime;
}