package cn.com.duiba.live.normal.service.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.live.LivePlaybackDto;
import cn.com.duiba.live.normal.service.api.param.live.PlaybackListParam;

import java.util.List;

/**
 *
 * @author dugq
 * @date 2020-04-29
 */
@AdvancedFeignClient
public interface RemoteLivePlaybackApiService {
    /**
     * 根据直播ID批量查询
     * @param liveId
     * @return
     */
    List<LivePlaybackDto> selectList(Long liveId);

    /**
     * 根据直播查询回放列表
     * @param liveId
     * @return
     */
    Long selectCount(Long liveId);

    /**
     * 查询回放列表
     * @param liveIds 直播主键集合
     * @return 上传的回放列表
     */
    List<LivePlaybackDto> selectListByLiveIds(List<Long> liveIds);

    /**
     * 查询有回放记录的直播ID
     * @param liveIds 直播ID集合
     * @return 有回放记录的直播ID集合
     */
    List<Long> findHasPlayBackLiveIds(List<Long> liveIds);

    /**
     * 新增回放记录
     * @param dto
     * @return
     */
    int insert(LivePlaybackDto dto);

    /**
     * 删除回放记录
     * @param id
     * @return
     */
    int delete(Long id);

    /**
     * 根据直播ID物理删除
     * @param liveId 直播ID
     * @return 执行结果
     */
    int deleteByLiveId(Long liveId);

    /**
     * 更新
     * @param dto 直播回放记录
     * @return 执行结果
     */
    int update(LivePlaybackDto dto);

    /**
     * 根据公司ID查询回放记录
     * @param param
     * @return
     */
    List<LivePlaybackDto> selectByCompanyId(PlaybackListParam param);
}
