package cn.com.duiba.live.normal.service.api.enums.push;

import com.google.common.collect.Lists;
import lombok.Getter;

import java.util.List;

/**
 * 指定中奖推送状态枚举
 *
 * @author 吴文哲
 * @date 2020/10/29 10:18 上午
 **/
@Getter
public enum PushStatus4SpecifyAwardEnum {

    INIT(0,"初始化"),
    PUSHING(1,"推送中"),
    SUCCESS(2,"推送成功"),
    FAILURE(3,"推送失败"),
    ;

    /**
     * 可以开始状态
     */
    public static final List<Integer> CAN_START_STATUS = Lists.newArrayList();


    static {
        CAN_START_STATUS.add(0);
        CAN_START_STATUS.add(3);
    }
    /**
     * 推送状态
     */
    private Integer status;

    /**
     * 描述
     */
    private String desc;

    PushStatus4SpecifyAwardEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }


}
