package cn.com.duiba.live.normal.service.api.enums.help;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 直播分享助力类型
 * @author lizhi
 * @date 2021/5/21 9:52 上午
 */
@Getter
@AllArgsConstructor
public enum LiveHelpShareTypeEnum {

    MP_SHARE(1, "普通小程序分享"),
    QUESTION_REWARD_MP_SHARE(2, "答题有奖小程序分享"),
    LOTTERY_MP_SHARE(3, "抽奖小程序分享"),
    GENERAL_RED_MP_SHARE(4, "普通红包小程序分享"),
    LUCK_RED_MP_SHARE(5, "手气王红包小程序分享"),
    GUESS_RED_MP_SHARE(6, "猜数字红包小程序分享"),
    FISSION_TREASURE_MP_SHARE(7, "裂变宝箱小程序分享"),
    FLIP_CARD_MP_SHARE(8,"翻牌裂变小程序分享"),
    PRE_MP_SHARE(9,"翻牌裂变小程序分享"),
    ;

    /**
     * 分享助力类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, LiveHelpShareTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(LiveHelpShareTypeEnum typeEnums : values()){
            ENUM_MAP.put(typeEnums.getType(), typeEnums);
        }
    }

    /**
     * 根据直播分享助力类型获取助力枚举
     * @param type 直播分享助力类型
     * @return 直播分享助力枚举
     */
    public static LiveHelpShareTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
