package cn.com.duiba.live.normal.service.api.remoteservice.live.push;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.live.push.LivePushDto;

import java.util.List;

/**
 * 直播推送
 * @author lizhi
 * @date 2020/7/23 10:49 AM
 */
@AdvancedFeignClient
public interface RemoteLivePushApiService {

    /**
     * 如果不存在，则新增（live_id + push_type 维度）
     * @param dto 推送配置
     * @return 是否成功
     */
    boolean saveIfAbsent(LivePushDto dto);

    /**
     * 根据liveId和推送类型查询推送配置
     *
     * @param liveId liveId
     * @param pushType 推送类型
     * @return 推送配置
     */
    LivePushDto selectByLiveIdAndType(Long liveId, Integer pushType);

    /**
     * 根据直播id和类型集合查询
     * @param liveId 直播id
     * @param types 类型集合
     * @return 推送配置信息
     */
    List<LivePushDto> findByLiveIdAndTypes(Long liveId, List<Integer> types);
}
