package cn.com.duiba.live.normal.service.api.remoteservice.liveclue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.liveclue.LiveClueReplyAdviceNewDto;

import java.util.List;

/**
 * 直播线索回复建议
 *
 * @author xuzhigang
 * @date 2020/8/31 3:06 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveClueReplyAdviceNewApiService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播线索回复建议新版
     */
    LiveClueReplyAdviceNewDto selectById(Long id);

    /**
     * 新增
     * @param dto 直播线索回复建议新版
     * @return 执行结果
     */
    int insert(LiveClueReplyAdviceNewDto dto);

    /**
     * 更新
     * @param dto 直播线索回复建议新版
     * @return 执行结果
     */
    int update(LiveClueReplyAdviceNewDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 批量插入
     *
     * @param entities 线索回复建议集合
     * @return 执行结果
     */
    int batchInsert(List<LiveClueReplyAdviceNewDto> entities);

    /**
     * 批量更新
     *
     * @param list 线索回复建议集合
     * @return 执行结果
     */
    int batchUpdate(List<LiveClueReplyAdviceNewDto> list);

    /**
     * 根据模板id查询回复建议列表
     *
     * @param templateId 模板id
     * @return 回复建议集合
     */
    List<LiveClueReplyAdviceNewDto> selectListByTemplateId(Long templateId);

    /**
     * 根据模板id删除
     * @param templateId 模板id
     * @return 执行结果
     */
    int deleteByTemplateId(Long templateId);
}
