package cn.com.duiba.live.normal.service.api.remoteservice.push;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.push.LivePushTaskDto;

import java.util.List;

/**
 * 直播推送任务服务接口
 * @author 吴文哲
 * @date 2020-08-20 16:32
 **/
@AdvancedFeignClient
public interface RemoteLivePushTaskApiService {

    /**
     * 插入直播推送任务
     * @param livePushTaskDto  直播推送任务对象
     * @return  数据库主键
     */
    Long addLivePushTask(LivePushTaskDto livePushTaskDto);

    /**
     * 累加 总数
     * @param id  主键
     * @param increaseTotalCount 单次新增的条数
     * @return
     */
    Integer increaseTotalCount(Long id,Integer increaseTotalCount);

    /**
     * 累加 消息发送成功数
     * @param id 主键
     * @param successCount 消息发送成功数量
     * @return
     */
    Integer increaseSuccessCount(Long id,Integer successCount);

    /**
     * 累加 消息发送失败数
     * @param id 主键
     * @param failureCount 消息发送失败数量
     * @return
     */
    Integer increaseFailureCount(Long id,Integer failureCount);


    /**
     * 根据主键查询
     * @param id  主键
     * @return
     */
    LivePushTaskDto findById(Long id);

    /**
     * 根据直播id和推送类型查询
     * @param liveId 直播id
     * @param types 类型集合
     * @return 推送任务信息
     */
    List<LivePushTaskDto> findByLiveIdAndTypes(Long liveId, List<Integer> types);
}
