package cn.com.duiba.live.normal.service.api.remoteservice.black;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.black.LiveBlackSourceDto;
import cn.com.duiba.live.normal.service.api.param.black.LiveBlackSourceSearchParam;

import java.util.List;

/**
 * 直播黑名单来源接口服务
 * @author 吴文哲
 * @date 2020-09-27 14:45
 **/
@AdvancedFeignClient
public interface RemoteLiveBlackSourceApiService {


    /**
     * 根据条件统计数量
     * @param searchParam 查询条件
     * @return 总数
     */
    long countByCondition(LiveBlackSourceSearchParam searchParam);

    /**
     * 根据条件查询列表
     * @param searchParam 直播黑名单源头查询参数
     * @return 黑名单源头列表
     */
    List<LiveBlackSourceDto> findByCondition(LiveBlackSourceSearchParam searchParam);


    /**
     * 批量插入
     * @param insertList 新增列表
     * @return 影响行数
     */
    int batchInsert(List<LiveBlackSourceDto> insertList);

    /**
     * 根据直播用户id查询 这些用户是否已经存在
     * @param sourceType
     * @see cn.com.duiba.live.normal.service.api.enums.live.blackList.SourceTypeEnum
     * @param liveUserIds 直播用户列表id
     * @param sourceType
     * @return 返回存在的用户id列表
     */
    List<Long> findExistsUserIds(List<Long> liveUserIds, Integer sourceType);

    /**
     * 增加封禁个数
     * @param sourceType
     * @see cn.com.duiba.live.normal.service.api.enums.live.blackList.SourceTypeEnum
     * @param liveUserId 直播用户id
     * @param banNum 封禁用户个数
     * @return 影响行数
     */
    int increaseBanNum(Integer sourceType, Long liveUserId,Integer banNum);

    /**
     * 封禁个数--
     * @param liveUserId 直播用户id
     * @return
     */
    int decreaseBanNum(Long liveUserId);

    /**
     * 累计封禁人数
     * @param param 查询参数
     * @return 累计封禁人数
     */
    Long sumBanNum(LiveBlackSourceSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键id
     * @return 直播黑名单源头用户对象
     */
    LiveBlackSourceDto findById(Long id);

    /**
     * 查询所有的简单的黑名单信息
     * @param sourceType
     * @see cn.com.duiba.live.normal.service.api.enums.live.blackList.SourceTypeEnum
     * @return
     */
    List<LiveBlackSourceDto> findAllListWithLocal(Integer sourceType);

    /**
     * 根据主键ids 查询直播黑名单用户来源列表
     * @param ids 主键id列表
     * @return 直播黑名单来源用户列表
     */
    List<LiveBlackSourceDto> findByIds(List<Long> ids);

    /**
     * 批量累计封禁人数
     * @param sourceDtoList
     * @return
     */
    int batchIncreaseBanNum(List<LiveBlackSourceDto> sourceDtoList);


    /**
     * 根据直播用户id 删除黑名单源头数据
     * @param liveUserId 直播用户id
     * @return 删除结果
     */
    boolean delBlackSource(Long liveUserId);
}
