package cn.com.duiba.live.normal.service.api.remoteservice.successcase;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.successcase.LiveSuccessCaseTempDto;
import cn.com.duiba.live.normal.service.api.dto.successcase.LiveSuccessCaseTempSimpleDto;
import cn.com.duiba.live.normal.service.api.param.livecase.LiveSuccessCaseTempSearchParam;

import java.util.List;
import java.util.Map;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020-07-23 14:42
 */
@AdvancedFeignClient
public interface RemoteLiveSuccessCaseTempApiService {

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return
     */
    List<LiveSuccessCaseTempDto> selectPage(LiveSuccessCaseTempSearchParam param);

    /**
     * 根据条件统计总数
     * @param param 查询条件
     * @return
     */
    Long selectCount(LiveSuccessCaseTempSearchParam param);

    /**
     * 保存
     * @param dto 成功案例模板
     * @return
     */
    int save(LiveSuccessCaseTempDto dto);

    /**
     * 修改
     * @param dto 成功案例模板
     * @return
     */
    int update(LiveSuccessCaseTempDto dto);

    /**
     * 物理删除成功案例模板
     * @param id 主键id
     * @return
     */
    int delete(Long id);

    /**
     * 根据主键id查询
     * @param id 主键id
     * @return 成功案例模板
     */
    LiveSuccessCaseTempDto findById(Long id);

    /**
     * 根据主键id查询基本信息（代理人id、海报地址）
     * @param ids 主键id集合
     * @return key：主键id value：基本信息（代理人id、海报地址）
     */
    Map<Long, LiveSuccessCaseTempSimpleDto> findSimpleInfoByIds(List<Long> ids);
}
