package cn.com.duiba.live.normal.service.api.dto.oto.cust;

import lombok.Data;

import java.io.Serializable;

/**
 * 客户通话表单记录表
 * @author kjj mybatis generator 
 * @date 2022-01-12
 */
@Data
public class CustCallRecordDto implements Serializable {
     
    private static final long serialVersionUID = 16419780996007343L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 销售id, tb_oto_seller.id
     */
    private Long sellerId;

    /**
     * 客户id, tb_oto_customer.id
     */
    private Long custId;

    /**
     * 通话记录日志id tb_cust_log_id
     */
    private Long callLogId;

    /**
     * 客户价值  1XX代表未接通 2XX中XX代表分数 3XX代表系统高价值
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustValueEnum
     */
    private Integer custValue;

    /**
     * 核心决策人 0:不明或其他 1:本人或配偶 2:子女 3：父母
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustCoreMakerEnum
     */
    private Integer coreMaker;

    /**
     * 标签id，用，隔开
     */
    private String tagIds;

    /**
     * 客户备注
     */
    private String custDescription;
}