package cn.com.duiba.live.normal.service.api.remoteservice.oto.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.cust.CustTagCountDto;

import java.util.List;

/**
 * OTO-客户标签信息
 *
 * @author ZhangJun
 * @date 2022/1/10 5:13 下午
 */
@AdvancedFeignClient
public interface RemoteOtoCustTagService {

    /**
     * 根据标签id删除所有客户标签关联关系
     *
     * @param tagId 标签id
     * @return 删除条数
     */
    boolean deleteByTagId(Long tagId);

    /**
     * 根据标签id统计客户人数
     *
     * @param tagIds 标签id
     * @return 客户人数
     */
    List<CustTagCountDto> batchCountByTagId(List<Long> tagIds);

}
