package cn.com.duiba.live.normal.service.api.remoteservice.spoke;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.spoke.LiveSpokeCategoryDto;

import java.util.List;
import java.util.Map;

/**
 * 直播评论类目表
 * @author kjj mybatis generator 
 * @date 2021-02-23
 */
@AdvancedFeignClient
public interface RemoteLiveSpokeCategoryService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播评论类目
     */
    LiveSpokeCategoryDto selectById(Long id);

    /**
     * 查询所有已开启的类目
     * @param status 状态，可不传，不传查所有
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     * @return 直播评论类目集合
     */
    List<LiveSpokeCategoryDto> findList(Integer status);

    /**
     * 根据主键id集合查询
     * @param ids 主键id集合
     * @return 直播评论类目集合
     */
    List<LiveSpokeCategoryDto> findByIds(List<Long> ids);

    /**
     * 根据类目名称查询，不like，全匹配，有索引
     * @param categoryName 类目名称
     * @return 直播评论类目
     */
    LiveSpokeCategoryDto selectByName(String categoryName);

    /**
     * 新增
     * @param dto 直播评论类目
     * @return 执行结果
     */
    int insert(LiveSpokeCategoryDto dto);

    /**
     * 更新
     * @param dto 直播评论类目
     * @return 执行结果
     */
    int update(LiveSpokeCategoryDto dto);

}