package cn.com.duiba.live.normal.service.api.enums.oto.cust.ext;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-11 14:17
 */
@Getter
@AllArgsConstructor
public enum OtoCustFamilyAttitudeEnum {

    NO_TALK(0, "未商量过"),
    UN_AGREE(1, "反对"),
    AGREE(2, "同意");

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustFamilyAttitudeEnum::getType, OtoCustFamilyAttitudeEnum::getDesc, (v1, v2)->v1)));

    /**
     * 根据类型获取描述
     */
    public static String getDescByType(Integer type){
        if (type == null) {
            return null;
        }
        return ALL_MAP.get(type);
    }
}
