package cn.com.duiba.live.normal.service.api.dto.oto.cust;

import cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustCoreMakerEnum;
import cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustForWhoEnum;
import cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustVisitProgressEnum;
import cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustWxStatusEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * OTO客户信息扩展表
 * @author kjj mybatis generator 
 * @date 2022-01-11
 */
@Data
public class OtoCustomerExtDto implements Serializable {
     
    private static final long serialVersionUID = 16418803615184972L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 客户id tb_oto_customer.id
     */
    private Long custId;

    /**
     * 加微状态  0:未主动发起加微 1:已主动添加-对方没反应 2:已主动添加-对方拒绝 3:已主动添加-对方已同意
     * @see OtoCustWxStatusEnum
     */
    private Integer addWxStatus;

    /**
     * 是否成交 0:否 1:是
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer dealFlag;

    /**
     * 是否提交计划书 0:否 1：是
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer commitPlanFlag;

    /**
     * 核心决策人 0:不明或其他 1:本人或配偶 2:子女 3：父母
     * @see OtoCustCoreMakerEnum
     */
    private Integer coreMaker;

    /**
     * 参观进度 0：无参观意向 1：未参观-有参观意向 2：已预约参观时间 3：完成参观
     * @see OtoCustVisitProgressEnum
     */
    private Integer visitProgress;

    /**
     * 为谁考虑(多选) 0:自己 1：父母 2:其他 3家人
     * @see OtoCustForWhoEnum
     */
    private String forWho;

    /**
     * 入住人出生年份
     */
    private Integer roomerBirthYear;

    /**
     * 入住人城市
     */
    private String roomerCity;

    /**
     * 考虑原因 0刚需 1未来 2了解一下
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustReasonEnum
     */
    private Integer considerReason;

    /**
     * 付费压力 0有压力 1略有压力 2无压力
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustPressureEnum
     */
    private Integer payPressure;

    /**
     * 退休金 0:0-5000 1:5000-8000 2: 8000-12000 3：12000+
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustRetireMoneyEnum
     */
    private Integer retireMoney;

    /**
     * 参观机构（多选） 0：国寿 1:泰康 2太平 3:其他
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustVisitOrgEnum
     */
    private String visitOrg;

    /**
     * 资金情况 0:不详 1:无资金 2:资金已到位 3:资金近期到位 4:资金明年到位
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustMoneyEnum
     */
    private Integer hasMoney;

    /**
     * 房产情况 
     */
    private Integer hasHouse;

    /**
     * 家人态度 0未商量过 1支持 2反对
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustFamilyAttitudeEnum
     */
    private Integer familyAttitude;
}