package cn.com.duiba.live.normal.service.api.dto.oto.log;

import lombok.Data;

import java.io.Serializable;

/**
 * 客户信息操作日志表
 * @author kjj mybatis generator 
 * @date 2022-01-11
 */
@Data
public class CustOptLogDto implements Serializable {
     
    private static final long serialVersionUID = 16418653040381368L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 操作人id
     */
    private Long operatorId;

    /**
     * 操作人姓名
     */
    private String operatorName;

    /**
     * 操作类型 0系统操作 1人为操作
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.log.OtoCustOperationTypeEnum
     */
    private Integer optType;

    /**
     * 操作场景
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.log.OtoCustOperationSceneEnum
     */
    private Integer optScene;

    /**
     * 轨迹id
     */
    private String traceId;

    /**
     * 操作key
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.log.OtoCustomerOptKeyEnum
     */
    private String optKey;

    /**
     * 老操作value
     */
    private String oldOptValue;

    /**
     * 新操作value
     */
    private String newOptValue;
}