package cn.com.duiba.live.normal.service.api.enums.live.push;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * 消息配置的标记
 * kjy-center: cn.com.duiba.kjy.api.enums.MessageMarkEnum
 *
 * @author xuzhigang
 * @date 2020/8/3 4:34 下午
 **/
@Getter
@AllArgsConstructor
public enum MessageMarkEnum {
    LIVE_USER_APPOINTMENT(140, "直播开播用户订阅消息"),
    LIVE_USER_DRAW(141, "访客领取权益订阅消息推送"),
    LIVE_USER_APPOINTMENT_LOTTERY(142, "直播预约活动开奖通知"),
    LIVE_USER_APPOINTMENT_RED(143, "直播预约红包领取通知"),
    LIVE_USER_NEXT_APPOINTMENT(144, "下场直播开播用户订阅消息"),
    LIVE_AGENT_VISITOR_LOTTERY(146, "代理人访客中奖通知"),
    LIVE_VISITOR_INVITE(147, "访客邀请结果通知"),
    LIVE_TREASURE_AWARD_CLAIM(148, "奖励领取通知"),
    LIVE_FLIP_WORD_DAILY_CHECKIN(149, "直播翻牌集字每日签到提醒"),
    LIVE_FISSION_LOTTERY_RECEIVED(232, "裂变抽奖券-领取通知"),
    LIVE_APPOINTMENT_WILL_START_REMIND(233, "订阅直播即将开始提醒"),
    RED_PACKET_RECEIVE_INFORM(234, "红包领取通知"),
    LOTTERY_RESULT_INFORM(235, "抽奖结果通知"),
    LIVE_SECOND_KILL_PRE_REMIND(237, "直播秒杀预告订阅提醒")

    ;

    /**
     * markId
     */
    private Integer mark;

    /**
     * 描述
     */
    private String desc;

    /**
     * 根据mark获取枚举
     *
     * @param mark markId
     * @return MessageMarkEnum
     */
    public static MessageMarkEnum getMessageMarkEnumByMark(Integer mark) {
        return Arrays.stream(values()).filter(messageMarkEnum -> Objects.equals(mark, messageMarkEnum.getMark()))
                .findFirst()
                .orElse(null);
    }
}
