package cn.com.duiba.live.normal.service.api.param.oto.cust;

import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-11 17:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class OtoCustomerSearchParam extends PageQuery {

    private static final long serialVersionUID = 2169640864944182855L;

    /**
     * 销售id
     */
    private Long otoSid;

    /**
     * 排序类型
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.OtoCustSortTypeEnum
     */
    private String sortType;

    /**
     * 客户分类枚举
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.follow.OtoCustClassifyEnum
     */
    private Integer custClassifyType;

    /**
     * 客户价值
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustValueEnum
     */
    private String custValue;

    /**
     * 标签id
     */
    private Long tagId;

    /**
     * 分配起始时间
     */
    private Date assignBeginTime;

    /**
     * 分配结束时间
     */
    private Date assignEndTime;

    /**
     * 跟进起始时间
     */
    private Date followBeginTime;

    /**
     * 跟进结束时间
     */
    private Date followEndTime;

    /**
     * 客户姓名
     */
    private String custName;
}
