package cn.com.duiba.live.normal.service.api.param.push;

import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 直播推送管理表
 * @author kjj mybatis generator 
 * @date 2020-07-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LivePushManagerSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15944381116834057L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 是否启用推送，0=未启用 1=启用
     */
    private Integer enableState;

    /**
     * 状态，1=未开始、2=成功、3=失败 4=执行中
     */
    private Integer pushState;

    /**
     * 起始推送时间 pushReleaseTime >= startPushReleaseTime
     */
    private Date startPushReleaseTime;

    /**
     * 结束推送时间 pushReleaseTime < endPushReleaseTime
     */
    private Date endPushReleaseTime;


}